// Here we go
var gulp = require('gulp'); 

// Add needed plugins
var plumber         = require('gulp-plumber');
var sass            = require('gulp-sass');
var postcss         = require('gulp-postcss');
var sourcemaps      = require('gulp-sourcemaps');
var autoprefixer    = require('autoprefixer');
var imagemin        = require('gulp-imagemin');
var pngquant        = require('imagemin-pngquant');
var minifyCss       = require('gulp-minify-css');
var concat          = require('gulp-concat');
var uglify          = require('gulp-uglify');
var async           = require('async');

// Copy js to dev
gulp.task('dev-js', function() {
    return gulp.src([
            './js/jquery.js',
            /* jquery plugins etc here */
            './js/main.js'
        ])
        .pipe(plumber())
        .pipe(sourcemaps.init())
        .pipe(concat('app.js'))
        .pipe(sourcemaps.write('./sourcemaps/'))
        .pipe(gulp.dest('./dev/js'))
});

// Compile Our Sass and run autoprefixer for CSS3 properties
gulp.task('dev-sass', function() {
    return gulp.src('./sass/*.scss')
        .pipe(plumber())
        .pipe(sourcemaps.init())
        .pipe(sass())
        .pipe(postcss(
            [ autoprefixer({ browsers: ['last 5 versions'] }) ]
        ))
        .pipe(sourcemaps.write('./sourcemaps/'))
        .pipe(gulp.dest('./dev/stylesheets'));
});

// Watch Files For Changes
gulp.task('watch', function() {
    gulp.watch('./js/*.js', ['dev-js']);
    gulp.watch('./sass/*.scss', ['dev-sass']);
});

/* run publish */
gulp.task('runprod', function(cb) {
    
    async.series([
        function (callback) {
            /* first copy the folder structure */
            console.log('/**** copy structure ****/');
            gulp.src(['./dev/**/*',
                      '!**/sourcemaps',
                      '!**/*.map',
                      '!./dev/image/*.png'
                ])
                .pipe(gulp.dest('dist'))
                .on('end', callback);
        },
        function (callback) {
            /* 
                1. minify
                2. create sourcemaps
                3. copy output to dist
            */
            console.log('/**** minify & copy css ****/');
            gulp.src('./dev/stylesheets/*.css')
                .pipe(plumber())
                //.pipe(sourcemaps.init())
                .pipe(minifyCss())
                //.pipe(sourcemaps.write('./sourcemaps/'))
                .pipe(gulp.dest('./dist/stylesheets'))
                .on('end', callback);
        },
        function (callback) {
            /* overwrite the dist png files with compressed ones */
            console.log('/**** compress images ****/');
            gulp.src('./dev/images/*.png')
                .pipe(plumber())
                .pipe(imagemin({
                    use: [pngquant()]
                }))
                .pipe(gulp.dest('./dist/images'))
                .on('end', callback);
        },
        function (callback) {
            /* concatenate and minify app javascript */
            console.log('/**** minify js ****/');
            gulp.src('./dev/js/*.js')
                .pipe(plumber())
                //.pipe(sourcemaps.init())
                .pipe(uglify())
                //.pipe(sourcemaps.write('./sourcemaps/'))
                .pipe(gulp.dest('./dist/js'))
                .on('end', callback);
        }
        ],
        function (err, values) {
            if (err) {
                console.log('failed');
                console.log(err);
                console.log(values);
            }
            else
            {
                console.log('success');
                cb();
            }
        }
    );
    
});

gulp.task('init', ['dev-js', 'dev-sass']);
gulp.task('publish', ['runprod']);
gulp.task('default', ['watch']);